begin
	require 'sketchup' # First we pull in the standard API hooks.
	require 'ShaDe//lib//utils.rb'
	require 'ShaDe//lib//geometry.rb'
	require 'ShaDe//lib//data-structures.rb'
rescue LoadError
	require "#{File.dirname(__FILE__)}/utils"
	require "#{File.dirname(__FILE__)}/geometry"
	require "#{File.dirname(__FILE__)}/data-structures"
end

#Author:: Manuela Ruiz  (mailto:mruiz@lcc.uma.es)
#Abstract representation of a Goal
class Goal
	#Name of the Goal
	attr_reader :name
	
	#Returns true iff the design complies the Goal
	def satisfied?()
		#The empty Goal always returns true
		return true
	end
	
	#Deletes the Goal
	def delete()
	end
end

#Author:: Manuela Ruiz  (mailto:mruiz@lcc.uma.es)
#A sort of goal: satisfied when there are no labels in the current shape
class NoLabelsGoal < Goal
	
	#Initialize the goal
	def initialize
		@name = Constants::NO_LABELS_GOAL_NAME
	end
	
	#returns:: true iff the current shape has no labels
	def satisfied?
		satisfied = true
		
		j = 0
		n_layers = Sketchup.active_model.layers.length
		layer_name = "Layer0"
		while (satisfied and (j < n_layers))
			layer_name = Sketchup.active_model.layers[j].name
		
			labels = Shade.project.execution.current_shape.p[layer_name]
			
			if (labels.size == 1) and (labels.first.key.value == Constants::INTERSECTION_LABEL)
				satisfied = false
			elsif (labels.size > 1)
				satisfied = false
			end
			
			j+=1
		end
	
		return satisfied
	end
end

#Author:: Manuela Ruiz  (mailto:mruiz@lcc.uma.es)
#A sort of goal: satisfied when all the rules in the grammar have been applied
class AllRulesAppliedGoal < Goal
	
	#Initialize the goal
	def initialize
		@name = Constants::ALL_RULES_APPLIED_GOAL_NAME
	end
	
	#returns:: true iff all the rules in the grammar have been applied
	def satisfied?
		satisfied = true
		
		if Shade.project.execution.execution_history
			i = 0
			while ((i < Shade.project.execution.grammar.rules.size) && (satisfied))
				rule_id = Shade.project.execution.grammar.rules[i].rule_id
				j = 0
				found = false
				while ((j < Shade.project.execution.execution_history.size) && (!found))
					if Shade.project.execution.execution_history[j][0] == rule_id
						found = true
					end
					j += 1
				end
				satisfied = found
				i += 1
			end
		else
			satisfied = false
		end
		
		return satisfied
	end
end

#Author:: Manuela Ruiz  (mailto:mruiz@lcc.uma.es)
#A sort of goal: satisfied when no more rules can be applied
class NoMoreRulesGoal < Goal
	#Initialize the goal
	def initialize
		@name = Constants::NO_MORE_RULES_GOAL_NAME
	end
	#returns:: true iff all no more rules of the grammar can be applied
	def satisfied?
		satisfied = true
		
		applied = Shade.project.execution.apply_rule_random
		if applied
			satisfied = false
			Shade.project.execution.undo
		end	

		return satisfied
	end
end